/////////////////////////////////////////////////////////////
// CINEMA SDK : OBJECT PLUGINS														 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// generator object example (with input objects)

#include "c4d.h"
#include "c4d_symbols.h"

class Gravitation : public ObjectData
{
	public:
		virtual Bool Draw						(PluginObject *op, LONG type, BaseDraw *bd, BaseDrawHelp *bh);
		virtual void ModifyParticles(PluginObject *op, Particle *pp, BaseParticle *ss, LONG pcnt, Real diff);
		virtual void GetDimension		(PluginObject *op, Vector *mp, Vector *rad);
	
		static NodeData *Alloc(void) { return gNew Gravitation; }
};

void Gravitation::GetDimension(PluginObject *op, Vector *mp, Vector *rad)
{
	*mp =0.0;
	*rad=100.0;
}

Bool Gravitation::Draw(PluginObject *op, LONG type, BaseDraw *bd, BaseDrawHelp *bh)
{
	if (type!=DRAWPASS_OBJECT) return TRUE;

	Matrix mg=bh->GetMg();
	Vector p[8],p9,p10,p11,p12;

	p9  = mg.off;
	p10 = p9  + Vector( 0.0,-50.0, 0.0);
	p11 = p10 + Vector( 5.0,  5.0, 0.0);
	p12 = p10 + Vector(-5.0,  5.0, 0.0);

	bd->SetPen(bd->GetObjectColor(bh,op));
	bd->Line3D(p9,p10);
	bd->Line3D(p10,p11);
	bd->Line3D(p10,p12);

	Vector rad=100.0;
	p[0] = Vector(-rad.x,-rad.y,-rad.z)*mg;
	p[1] = Vector( rad.x,-rad.y,-rad.z)*mg;
	p[2] = Vector( rad.x,-rad.y, rad.z)*mg;
	p[3] = Vector(-rad.x,-rad.y, rad.z)*mg;

	p[4] = Vector(-rad.x, rad.y,-rad.z)*mg;
	p[5] = Vector( rad.x, rad.y,-rad.z)*mg;
	p[6] = Vector( rad.x, rad.y, rad.z)*mg;
	p[7] = Vector(-rad.x, rad.y, rad.z)*mg;

	bd->Line3D(p[0],p[1]); bd->Line3D(p[1],p[2]); bd->Line3D(p[2],p[3]); bd->Line3D(p[3],p[0]);
	bd->Line3D(p[4],p[5]); bd->Line3D(p[5],p[6]);	bd->Line3D(p[6],p[7]); bd->Line3D(p[7],p[4]);
	bd->Line3D(p[0],p[4]); bd->Line3D(p[1],p[5]); bd->Line3D(p[2],p[6]); bd->Line3D(p[3],p[7]);

	return TRUE;
}

void Gravitation::ModifyParticles(PluginObject *op, Particle *ps, BaseParticle *ss, LONG pcnt, Real diff)
{
	LONG					i;
	Vector				pp,vv,l=100.0;
	Real					amp=diff*250.0;
	Matrix				mg=op->GetMg(), img=!mg;

	for (i=0; i<pcnt; i++)
	{
		if (!(ps[i].bits & PARTICLE_VISIBLE)) continue;
		pp = ps[i].off * img;
		vv = ps[i].v3;
		if (pp.x>=-l.x && pp.x<=l.x && pp.y>=-l.y && pp.y<=l.y && pp.z>=-l.z && pp.z<=l.z)
		{
			vv.y -= amp;
			ss[i].v += vv;
			ss[i].count++;
		}
	}
}

// be sure to use a unique ID obtained from www.plugincafe.com
#define ID_GRAVITATIONOBJECT 1001155

Bool RegisterGravitation(void)
{
	// decide by name if the plugin shall be registered - just for user convenience
	String name=GeLoadString(IDS_GRAVITATION); if (!name.Content()) return TRUE;
	return RegisterObjectPlugin(ID_GRAVITATIONOBJECT,name,OBJECT_PARTICLEMODIFIER,Gravitation::Alloc,"","gravitation.tif","gravitation_small.tif",0);
}
